package gov.va.genisis2.dao.impl;

import static org.junit.Assert.assertNotNull;

import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.dao.IUserTypeDao;
import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.model.UserType;

@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public class UserTypeDaoTest extends AbstractMockMvcTests {

	@Autowired
	private IUserTypeDao userTypeDao;
	private UserTypeDao userTypeDao_SF_NULL;

	/**
	 * Test getUserType.
	 * 
	 * @throws GenisisDAOException
	 */

	@Test
	public void testGetUserType() throws GenisisDAOException {

		UserType userType = userTypeDao.getUserType(1);
		assertNotNull(userType);

	}

	/**
	 * Test getUserType.
	 * 
	 * @throws GenisisDAOException
	 */

	@Test(expected = GenisisDAOException.class)
	public void testGetUserType_SF_NULL() throws GenisisDAOException {

		setSessionFactory_Null();
		userTypeDao_SF_NULL.getUserType(0);

	}

	private void setSessionFactory_Null() {
		userTypeDao_SF_NULL = new UserTypeDao();
		userTypeDao_SF_NULL.setSessionFactory(null);
	}

}
